#pragma once

#include <macs_pg/collectors/collector.h>

namespace macs {

class CollectorFactory : private CollectorDataInterface<CollectorFactory>
{
    friend class CollectorDataInterface<CollectorFactory>;
public:
#define MODIFIER(NAME) \
    CollectorFactory& NAME(decltype(CollectorData::NAME) value) { \
        data().NAME = std::move(value); \
        return *this; \
    }

    MODIFIER(uid)
    MODIFIER(collectorId)
    MODIFIER(srcUid)
    MODIFIER(authToken)
    MODIFIER(rootFolderId)
    MODIFIER(labelId)
    MODIFIER(ignoreFoldersStruct)
    MODIFIER(creationTs)
    MODIFIER(lastMid)
    MODIFIER(skippedMids)
    MODIFIER(state)
    MODIFIER(oldPopid)
    MODIFIER(migratedLastMid)
    MODIFIER(originalServer)
    MODIFIER(migrationTargetState)
#undef MODIFIER

    const CollectorDataInterface<CollectorFactory>& product() const {
        return *this;
    }

    CollectorFactory& reset() {
        data_.reset();
        return *this;
    }

    Collector release() {
        auto result = Collector{ std::move(data_) };
        reset();
        return result;
    }

    CollectorFactory(const Collector& src) : data_(std::make_shared<CollectorData>(src.data())) {}

    CollectorFactory() = default;
    CollectorFactory(const CollectorFactory& ) = delete;
    CollectorFactory(CollectorFactory&&) = default;
    CollectorFactory& operator=(const CollectorFactory&) = delete;
    CollectorFactory& operator=(CollectorFactory&&) = default;

private:
    CollectorData& data() {
        if (!data_) {
            data_ = std::make_shared<CollectorData>();
        }
        return *data_;
    }

    const CollectorData& data() const {
        return data_ ? *data_ : CollectorData::default_;
    }

    std::shared_ptr<CollectorData> data_;
};

} // namespace macs
