#ifndef _MACS_PG_COMMON_CONFIGURE_H_
#define _MACS_PG_COMMON_CONFIGURE_H_

#include <string>

#include <boost/property_tree/ptree.hpp>

#include <pgg/service/uid_resolver.h>
#include <pgg/service/shard_resolver.h>
#include <macs_pg/service/factory.h>
#include <pgg/database/pool_factory.h>
#include <pgg/database/statistic.h>

#include <sharpei_client/sharpei_client.h>

namespace macs {
namespace pg {

using pgg::ConnectionPoolPtr;
using pgg::Credentials;
using pgg::Milliseconds;
using pgg::Seconds;
using pgg::UidResolverFactoryPtr;
using pgg::ShardResolverFactoryPtr;

namespace integration {

class CommonConfigure {
    using ptree = boost::property_tree::ptree;
    macs::pg::QueryConf conf;
    macs::pg::ConnectionPoolPtr pool;
    macs::pg::Credentials credentials_;
    Milliseconds transactionTimeout_;

    static macs::pg::UidResolverFactoryPtr sharpei(sharpei::client::http::HttpClientPtr h,
            const sharpei::client::Settings& s,
            const macs::pg::Credentials& c);
    static macs::pg::UidResolverFactoryPtr directPg( const std::string& connString,
                                                     const std::string& shardName );

    static macs::pg::Credentials parseCredentials(const ptree& pgTree);
    static macs::pg::QueryConf parseQueryConf(const ptree& pgTree);
    static macs::pg::ConnectionPoolPtr parseConnectionPool(const ptree& pgTree, boost::asio::io_context* ctx);

    CommonConfigure& queryConf( macs::pg::QueryConf v );
    CommonConfigure& connPool( macs::pg::ConnectionPoolPtr v );
    CommonConfigure& credentials( macs::pg::Credentials v );

public:
    static macs::pg::UidResolverFactoryPtr parseUidResolverFactory(const ptree& tree,
            sharpei::client::http::HttpClientPtr h = nullptr,
            sharpei::client::Settings::HttpExceptionHandler onHttpExc
                    = sharpei::client::Settings::HttpExceptionHandler(),
            sharpei::client::Settings::HttpErrorHandler onHttpErr
                    = sharpei::client::Settings::HttpErrorHandler());

    CommonConfigure& parse(const ptree& tree);
    CommonConfigure& parse(const ptree& tree, boost::asio::io_context* ctx);

    inline pgg::statistic::ConnectionPoolStats getPoolStats() const {
        return pgg::statistic::getPoolStats(*pool);
    }

    macs::pg::ServiceFactoryPtr getFactory(macs::pg::UidResolverFactoryPtr resolverFactory,
            macs::pg::ShardResolverFactoryPtr shardResolverFactory = nullptr) const;
};

}}}

#endif /* _MACS_PG_COMMON_CONFIGURE_H_ */
