#ifndef MACS_PG_PROFILER_H_
#define MACS_PG_PROFILER_H_

#include <pa/async.h>
#include <pgg/profiling.h>

namespace macs {
namespace pg {
namespace integration {

// Not for using in macs_pg inself. Just a common realization of profiling interface
class PaProfiler : public pgg::profiling::Log {
public :
    using Profiler = pa::async_profiler;

    virtual void write( const std::string & operation,
            const std::string & info, pgg::Duration duration ) const override {
        Profiler::add (pa::postgresql, "macs_pg", operation, info,
                static_cast<uint32_t>(pgg::Milliseconds(duration).count() ));
    }

    static pgg::profiling::LogPtr create() {
        return pgg::profiling::LogPtr(new PaProfiler());
    }
};

}}}

#endif /* MACS_PG_PROFILER_H_ */
