#ifndef INCLUDE_MACS_PG_LOGGING_H_
#define INCLUDE_MACS_PG_LOGGING_H_

#include <pgg/logging.h>
#include <pgg/logdog.h>

namespace macs {
namespace pg {
namespace logging {

using pgg::logging::Message;
using pgg::logging::Method;

inline namespace v1 {

class Log {
public:
    virtual ~Log() = default;
    virtual void warning(const Method&, const Message&) = 0;
    virtual void error(const Method&, const Message&) = 0;
    virtual void notice(const Method&, const Message&) = 0;
    virtual void debug(const Method&, const Message&) = 0;
};

using LogPtr = boost::shared_ptr<Log>;

} // namespace v1

namespace v2 {

using pgg::logging::Log;
using pgg::logging::LogPtr;
using pgg::logging::TypedLog;

} // namespace v2

v2::LogPtr adaptLog(LogPtr log);

using pgg::logging::Level;
using pgg::logging::Attribute;
using pgg::logging::Attributes;
using pgg::logging::Record;

using pgg::logging::QueryText;
using pgg::logging::QueryValues;
using pgg::logging::ConnectionInfo;
using pgg::logging::RuleName;
using pgg::logging::OldMessage;

using pgg::logging::logWithLevel;
using pgg::logging::logError;
using pgg::logging::logWarning;
using pgg::logging::logNotice;
using pgg::logging::logDebug;

} // namespace logging
} // namespace pg
} // namesopace macs

#endif /* INCLUDE_MACS_PG_LOGGING_H_ */
