#pragma once

#include <ctime>
#include <string>
#include <memory>
#include <vector>

namespace macs {

class MailishAccount {
public:
#define GETTER(NAME) auto& NAME() const { return data().NAME; }
    GETTER(uid)
    GETTER(email)
    GETTER(imapLogin)
    GETTER(imapSsl)
    GETTER(imapServer)
    GETTER(imapPort)
    GETTER(smtpLogin)
    GETTER(smtpSsl)
    GETTER(smtpServer)
    GETTER(smtpPort)
    GETTER(lastSyncTs)
#undef GETTER

    MailishAccount() = default;

private:
    friend class MailishAccountFactory;

    struct Data {
        std::string uid;
        std::string email;
        std::string imapLogin;
        bool imapSsl = true;
        std::string imapServer;
        uint32_t imapPort = 0;
        std::string smtpLogin;
        bool smtpSsl = true;
        std::string smtpServer;
        uint32_t smtpPort = 0;
        std::time_t lastSyncTs = 0;

        static const Data default_;
    };

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    MailishAccount(std::shared_ptr<const Data> data): data_(std::move(data)) { }

    std::shared_ptr<const Data> data_;
};

using MailishAccountChunk = std::vector<MailishAccount>;

} // namespace macs
