#pragma once

#include <macs_pg/mailish/account.h>

namespace macs {

class MailishAccountFactory {
    using Data = MailishAccount::Data;
public:
#define MODIFIER(NAME) \
    MailishAccountFactory& NAME(decltype(Data::NAME) value) { \
        data().NAME = std::move(value); \
        return *this; \
    }

    MODIFIER(uid)
    MODIFIER(email)
    MODIFIER(imapLogin)
    MODIFIER(imapSsl)
    MODIFIER(imapServer)
    MODIFIER(imapPort)
    MODIFIER(smtpLogin)
    MODIFIER(smtpSsl)
    MODIFIER(smtpServer)
    MODIFIER(smtpPort)
    MODIFIER(lastSyncTs)
#undef MODIFIER

    MailishAccount release() {
        auto result = MailishAccount{ std::move(data_) };
        reset();
        return result;
    }

    MailishAccountFactory& reset() {
        data_.reset();
        return *this;
    }

private:
    Data& data() {
        if (!data_) {
            data_ = std::make_shared<Data>();
        }
        return *data_;
    }

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    std::shared_ptr<Data> data_;
};

} // namespace macs
