#pragma once

#include <string>
#include <vector>
#include <memory>
#include <ctime>

namespace macs {

class MailishAuthData {
public:
#define GETTER(NAME) auto& NAME() const { return data().NAME; }
    GETTER(tokenId)
    GETTER(authType)
    GETTER(uuid)
    GETTER(lockFlag)
    GETTER(lastValid)
    GETTER(oauthApplication)
    GETTER(imapCredentials)
    GETTER(smtpCredentials)
#undef GETTER

    enum class AuthType {
        Undefined,
        OAuth2,
        Password
    };

    MailishAuthData() = default;

private:
    friend class MailishAuthDataFactory;

    struct Data {
        std::string tokenId;
        AuthType authType = AuthType::Undefined;
        std::string uuid;
        bool lockFlag = false;
        std::time_t lastValid = 0;
        std::string oauthApplication;
        std::string imapCredentials;
        std::string smtpCredentials;

        static const Data default_;
    };

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    MailishAuthData(std::shared_ptr<const Data> data): data_(std::move(data)) { }

    std::shared_ptr<const Data> data_;
};

using MailishAuthDataChunk = std::vector<MailishAuthData>;

} // namespace macs
