#pragma once

#include <macs_pg/mailish/auth_data.h>

namespace macs {

class MailishAuthDataFactory {
    using Data = MailishAuthData::Data;
public:
#define MODIFIER(NAME) \
    MailishAuthDataFactory& NAME(decltype(Data::NAME) value) { \
        data().NAME = std::move(value); \
        return *this; \
    }

    MODIFIER(tokenId)
    MODIFIER(authType)
    MODIFIER(uuid)
    MODIFIER(lockFlag)
    MODIFIER(lastValid)
    MODIFIER(oauthApplication)
    MODIFIER(imapCredentials)
    MODIFIER(smtpCredentials)
#undef MODIFIER

    MailishAuthData release() {
        auto result = MailishAuthData{ std::move(data_) };
        reset();
        return result;
    }

    MailishAuthDataFactory& reset() {
        data_.reset();
        return *this;
    }

private:
    Data& data() {
        if (!data_) {
            data_ = std::make_shared<Data>();
        }
        return *data_;
    }

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    std::shared_ptr<Data> data_;
};

} // namespace macs
