#pragma once

namespace macs {

class MailishEntry {
public:
#define GETTER(NAME) auto& NAME() const { return data().NAME; }
    GETTER(uid)
    GETTER(fid)
    GETTER(foreignImapId)
    GETTER(foreignReceiveTime)
    GETTER(errorsCount)
#undef GETTER

    MailishEntry() = default;

private:
    friend class MailishEntryFactory;

    struct Data {
        std::string uid;
        std::string fid;
        std::string foreignImapId;
        std::time_t foreignReceiveTime;
        uint32_t errorsCount;

        static const Data default_;
    };

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    MailishEntry(std::shared_ptr<const Data> data): data_(std::move(data)) { }

    std::shared_ptr<const Data> data_;
};

} // namespace macs
