#pragma once

#include <macs_pg/mailish/entry.h>

namespace macs {

class MailishEntryFactory {
    using Data = MailishEntry::Data;
public:
#define MODIFIER(NAME) \
    MailishEntryFactory& NAME(decltype(Data::NAME) value) { \
        data().NAME = std::move(value); \
        return *this; \
    }

    MODIFIER(uid)
    MODIFIER(fid)
    MODIFIER(foreignImapId)
    MODIFIER(foreignReceiveTime)
    MODIFIER(errorsCount)
#undef MODIFIER

    MailishEntry release() {
        auto result = MailishEntry{ std::move(data_) };
        reset();
        return result;
    }

    MailishEntryFactory& reset() {
        data_.reset();
        return *this;
    }

private:
    Data& data() {
        if (!data_) {
            data_ = std::make_shared<Data>();
        }
        return *data_;
    }

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    std::shared_ptr<Data> data_;
};

} // namespace macs
