#pragma once

#include <memory>
#include <string>
#include <vector>

namespace macs {

class MailishFolder {
public:
#define GETTER(NAME) auto& NAME () const { return data().NAME; }
    GETTER(fid)
    GETTER(path)
    GETTER(uidValidity)
    GETTER(downloadedRangeBegin)
    GETTER(downloadedRangeEnd)
#undef GETTER

    MailishFolder() = default;

private:
    friend class MailishFolderFactory;

    struct Data {
        std::string fid;
        std::string path;
        uint64_t uidValidity;
        uint32_t downloadedRangeBegin = 0;
        uint32_t downloadedRangeEnd = 0;

        static const Data default_;
    };

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    MailishFolder(std::shared_ptr<const Data> data): data_(std::move(data)) { }

    std::shared_ptr<const Data> data_;
};

using MailishFolderChunk = std::vector<MailishFolder>;

} // namespace macs
