#pragma once

#include <macs_pg/mailish/folder.h>

namespace macs {

class MailishFolderFactory {
    using Data = MailishFolder::Data;
public:
#define MODIFIER(NAME) \
    MailishFolderFactory& NAME (decltype(Data::NAME) value) { \
        data().NAME = std::move(value); \
        return *this; \
    }

    MODIFIER(fid)
    MODIFIER(path)
    MODIFIER(uidValidity)
    MODIFIER(downloadedRangeBegin)
    MODIFIER(downloadedRangeEnd)
#undef MODIFIER

    MailishFolder release() {
        auto result = MailishFolder{ std::move(data_) };
        reset();
        return result;
    }

    MailishFolderFactory& reset() {
        data_.reset();
        return *this;
    }

private:
    Data& data() {
        if (!data_) {
            data_ = std::make_shared<Data>();
        }
        return *data_;
    }

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    std::shared_ptr<Data> data_;
};

} // namespace macs
