#pragma once

#include <memory>
#include <string>
#include <boost/optional.hpp>

namespace macs {

class MailishFolderInfo {
public:
#define GETTER(NAME) auto& NAME () const { return data().NAME; }
    GETTER(externalPath)
    GETTER(uidValidity)
#undef GETTER

    MailishFolderInfo() = default;

private:
    friend class MailishFolderInfoFactory;

    struct Data {
        std::string externalPath;
        uint64_t uidValidity = 0;

        static const Data default_;
    };

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    MailishFolderInfo(std::shared_ptr<const Data> data): data_(std::move(data)) { }

    std::shared_ptr<const Data> data_;
};

using MailishFolderInfoOpt = boost::optional<MailishFolderInfo>;

} // namespace macs
