#pragma once

#include <macs_pg/mailish/folder.h>

namespace macs {

class MailishFolderInfoFactory {
    using Data = MailishFolderInfo::Data;
public:
#define MODIFIER(NAME) \
    MailishFolderInfoFactory& NAME (decltype(Data::NAME) value) { \
        data().NAME = std::move(value); \
        return *this; \
    }

    MODIFIER(externalPath)
    MODIFIER(uidValidity)
#undef MODIFIER

    MailishFolderInfo release() {
        auto result = MailishFolderInfo{ std::move(data_) };
        reset();
        return result;
    }

    MailishFolderInfoFactory& reset() {
        data_.reset();
        return *this;
    }

private:
    Data& data() {
        if (!data_) {
            data_ = std::make_shared<Data>();
        }
        return *data_;
    }

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    std::shared_ptr<Data> data_;
};

} // namespace macs
