#pragma once

#include <ctime>
#include <memory>
#include <string>
#include <vector>


namespace macs {

class MailishMessage {
public:
#define GETTER(NAME) auto& NAME () const { return data().NAME; }
    GETTER(uid)
    GETTER(externalImapId)
    GETTER(fid)
    GETTER(mid)
    GETTER(externalReceivedDate)
    GETTER(errors)
#undef GETTER

    MailishMessage() = default;

private:
    friend class MailishMessageFactory;

    struct Data {
        std::string uid;
        std::string externalImapId;
        std::string fid;
        std::string mid;
        std::time_t externalReceivedDate = 0;
        int errors = 0;

        static const Data default_;
    };

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    MailishMessage(std::shared_ptr<const Data> data): data_(std::move(data)) { }

    std::shared_ptr<const Data> data_;
};

using MailishMessageChunk = std::vector<MailishMessage>;

} // namespace macs
