#pragma once

#include <macs_pg/mailish/message.h>

namespace macs {

class MailishMessageFactory {
    using Data = MailishMessage::Data;
public:
#define MODIFIER(NAME) \
    MailishMessageFactory& NAME (decltype(Data::NAME) value) { \
        data().NAME = std::move(value); \
        return *this; \
    }

    MODIFIER(uid)
    MODIFIER(externalImapId)
    MODIFIER(fid)
    MODIFIER(mid)
    MODIFIER(externalReceivedDate)
    MODIFIER(errors)
#undef MODIFIER

    MailishMessage release() {
        auto result = MailishMessage{ std::move(data_) };
        reset();
        return result;
    }

    MailishMessageFactory& reset() {
        data_.reset();
        return *this;
    }

private:
    Data& data() {
        if (!data_) {
            data_ = std::make_shared<Data>();
        }
        return *data_;
    }

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    std::shared_ptr<Data> data_;
};

} // namespace macs
