#pragma once

#include <memory>
#include <string>
#include <vector>

namespace macs {

class MailishMoveCoords {
public:
#define GETTER(NAME) auto& NAME () const { return data().NAME; }
    GETTER(curImapId)
    GETTER(newImapId)
    GETTER(mid)
#undef GETTER

    MailishMoveCoords() = default;

private:
    friend class MailishMoveCoordsFactory;

    struct Data {
        uint64_t curImapId = 0;
        uint64_t newImapId = 0;
        std::string mid;

        static const Data default_;
    };

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    MailishMoveCoords(std::shared_ptr<const Data> data): data_(std::move(data)) { }

    std::shared_ptr<const Data> data_;
};

using MailishMoveCoordsChunk = std::vector<MailishMoveCoords>;

} // namespace macs
