#pragma once

#include <macs_pg/mailish/move_coords.h>

namespace macs {

class MailishMoveCoordsFactory {
    using Data = MailishMoveCoords::Data;
public:
#define MODIFIER(NAME) \
    MailishMoveCoordsFactory& NAME (decltype(Data::NAME) value) { \
        data().NAME = std::move(value); \
        return *this; \
    }

    MODIFIER(curImapId)
    MODIFIER(newImapId)
    MODIFIER(mid)
#undef MODIFIER

    MailishMoveCoords release() {
        auto result = MailishMoveCoords{ std::move(data_) };
        reset();
        return result;
    }

    MailishMoveCoordsFactory& reset() {
        data_.reset();
        return *this;
    }

private:
    Data& data() {
        if (!data_) {
            data_ = std::make_shared<Data>();
        }
        return *data_;
    }

    const Data& data() const {
        return data_ ? *data_ : Data::default_;
    }

    std::shared_ptr<Data> data_;
};

} // namespace macs
