#pragma once

#include <macs/io.h>
#include <macs_pg/hooks.h>

namespace macs {


class MailishAccountsRepository : public std::enable_shared_from_this<MailishAccountsRepository> {
public:
    virtual ~MailishAccountsRepository() = default;

    template <typename Handler = io::sync_context>
    auto getUsers(Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnShardUserList> init(handler);
        asyncGetUsers(init.handler);
        return init.result.get();
    }

    template <typename Handler = io::sync_context>
    auto getChanges(std::time_t lastMovedDate, std::time_t lastDeletedDate, Handler handler = io::use_sync) const {
        io::detail::init_async_result<Handler, OnShardUserList> init(handler);
        asyncGetChanges(lastMovedDate, lastDeletedDate, init.handler);
        return init.result.get();
    }

protected:
    virtual void asyncGetUsers(OnShardUserList hook) const = 0;
    virtual void asyncGetChanges(std::time_t lastMovedDate, std::time_t lastDeletedDate, OnShardUserList hook) const = 0;
};


typedef std::shared_ptr<MailishAccountsRepository> MailishAccountsRepositoryPtr;

} // namespace macs

