#pragma once

#include <macs_pg/service/service.h>
#include <macs_pg/service/shard.h>
#include <pgg/service/uid_resolver.h>
#include <pgg/service/shard_resolver.h>
#include <pgg/profiling.h>
#include <macs_pg/logging.h>
#include <pgg/request_info.h>
#include <pgg/chrono.h>
#include <pgg/factory.h>

namespace macs {
namespace pg {
namespace profiling {
using namespace pgg::profiling;
} // namespace profiling

using pgg::ConnectionPoolPtr;
using pgg::ConnectionPoolFactory;
using pgg::Credentials;
using pgg::RequestInfo;
using pgg::QueryConf;
using pgg::QueryHandleStrategy;
using pgg::Milliseconds;

using pgg::createFakeUidResolverFactory;
using pgg::createFakeShardResolverFactory;
using pgg::createSharpeiUidResolverFactory;
using pgg::createShardResolverFactory;

using UserType = pgg::UidResolver::UserType;

QueryConf readQueryConfFile( const std::string & fileName );

extern const QueryHandleStrategy readMasterThenReplica;
extern const QueryHandleStrategy masterOnly;
extern const QueryHandleStrategy readReplicaThenMaster;
extern const QueryHandleStrategy replicaOnly;
extern const QueryHandleStrategy readNoLagReplicaThenMasterThenReplica;

/**
 * Interface for the Service object factory
 */
struct ServiceFactory {
    typedef macs::ServicePtr Product;
    typedef macs::ShardPtr ShardProduct;
    typedef ServiceFactory Self;
    typedef pgg::Milliseconds Milliseconds;
    typedef pgg::UidResolver::Id Uid;
    typedef pgg::ShardResolver::Id ShardId;
    typedef std::unique_ptr<ServiceFactory> Ptr;

    virtual Self & userJournal( user_journal::Journal journal ) = 0;
    virtual Self & profiler(profiling::LogPtr v) = 0;
    virtual Self & logger(logging::v1::LogPtr v) = 0;
    virtual Self & logger(logging::v2::LogPtr v) = 0;
    virtual Self & queryConf(QueryConf v) = 0;
    virtual Self & credentials(Credentials v) = 0;
    virtual Self & autoQueryHandleStartegy( const QueryHandleStrategy &) = 0;
    virtual Self & requestInfo(RequestInfo reqInfo) = 0;
    virtual Self & transactionTimeout(Milliseconds tt) = 0;

    virtual Product product( const Uid & uid, UserType userType = UserType::existing ) const = 0;
    virtual Product mailbox( const Uid & uid, UserType userType = UserType::existing ) const = 0;
    virtual ShardProduct shard( const ShardId & shardId ) const = 0;

    virtual Ptr clone() const = 0;

    virtual ~ServiceFactory() {}
};

typedef ServiceFactory::Ptr ServiceFactoryPtr;

} // namespace pg
} // namespace macs

