#pragma once

#include <macs/envelopes_repository.h>
#include <macs/labels_repository.h>
#include <macs/folders_repository.h>
#include <macs/imap_repository.h>
#include <macs/database_info.h>
#include <macs/threads_repository.h>
#include <macs_pg/shared_folders/repository.h>
#include <macs_pg/subscribed_folders/repository.h>
#include <macs_pg/subscription/repository.h>
#include <macs_pg/mailish/repository.h>
#include <macs_pg/changelog/repository.h>
#include <macs/tabs_repository.h>
#include <macs_pg/collectors/repository.h>
#include <macs/settings_repository.h>
#include <macs/users_repository.h>
#include <macs/backups_repository.h>
#include <macs/stickers_repository.h>

namespace macs {

/**
 * Service abstraction to replace macs::MailMetadata in the future
 */
struct Service {
    virtual ~Service() {}

    virtual EnvelopesRepository & envelopes() = 0;
    virtual const EnvelopesRepository & envelopes() const = 0;
    virtual FoldersRepository & folders() = 0;
    virtual const FoldersRepository & folders() const = 0;
    virtual LabelsRepository & labels() = 0;
    virtual const LabelsRepository & labels() const = 0;
    virtual ImapRepository & imapRepo() = 0;
    virtual const ImapRepository & imapRepo() const = 0;
    virtual const DatabaseInfo & databaseInfo() const = 0;
    virtual DatabaseInfo & databaseInfo() = 0;

    virtual ThreadsRepository & threads() = 0;
    virtual const ThreadsRepository & threads() const = 0;

    virtual const SharedFoldersRepository & sharedFolders() const = 0;
    virtual const SubscribedFoldersRepository & subscribedFolders() const = 0;
    virtual const SubscriptionRepository & subscriptions() const = 0;

    virtual const MailishRepository & mailish() const = 0;
    virtual const UserChangeLogRepository& changelog() const = 0;

    virtual const TabsRepository& tabs() const = 0;

    virtual const CollectorsRepository& collectors() const = 0;

    virtual const SettingsRepository& settings() const = 0;
    virtual SettingsRepository& settings() = 0;

    virtual const UsersRepository& users() const = 0;

    virtual const BackupsRepository& backups() const = 0;

    virtual const StickersRepository& stickers() const = 0;


    using TransactionBodyFunc = std::function<void(boost::shared_ptr<Service>, std::function<void(error_code)>)>;

    template <typename Handler>
    void runTransactional(TransactionBodyFunc func, Handler handler) const {
        io::detail::init_async_result<Handler, OnExecute> init(handler);
        runTransactionalInternal(func, init.handler);
        return init.result.get();
    }

protected:
    virtual void runTransactionalInternal(TransactionBodyFunc func, OnExecute hook) const = 0;
};

typedef boost::shared_ptr<Service> ServicePtr;

} //namespace macs
