#ifndef MACS_SHARD_H_27022017
#define MACS_SHARD_H_27022017

#include <macs/database_info.h>
#include <macs_pg/changelog/repository.h>
#include <macs_pg/subscription/repository.h>
#include <macs_pg/change_queue/repository.h>
#include <macs_pg/mailish_accounts/repository.h>
#include <macs_pg/collectors/shard_repository.h>

namespace macs {

/**
 * Shard - access for per shard meta
 */
struct Shard {
    virtual ~Shard() = default;

    virtual const DatabaseInfo & databaseInfo() const = 0;
    virtual const ChangeLogRepository & changeLog() const = 0;
    virtual const SubscriptionRepository & subscriptions() const = 0;
    virtual const ChangeQueueRepository & changeQueue() const = 0;
    virtual const MailishAccountsRepository & mailishAccounts() const = 0;
    virtual const CollectorsShardRepository & collectors() const = 0;
};

typedef std::shared_ptr<Shard> ShardPtr;

} //namespace macs


#endif /* MACS_SHARD_H_27022017 */
