#ifndef MACS_SUBSCRIBED_FOLDER_FACTORY_H
#define MACS_SUBSCRIBED_FOLDER_FACTORY_H

#include <macs_pg/subscribed_folders/subscribed_folder.h>

namespace macs {

class SubscribedFolderFactory: private SubscribedFolderDataInterface<SubscribedFolderFactory> {
public:

#define MODIFIER(NAME) \
    SubscribedFolderFactory & NAME (const decltype(SubscribedFolderData::NAME) & v) { \
        data().NAME = std::move(v); \
        return *this; \
    }

    MODIFIER(uid)
    MODIFIER(fid)
    MODIFIER(revision)
    MODIFIER(ownerUid)
    MODIFIER(ownerFid)
    MODIFIER(syncedRevision)
    MODIFIER(created)

#undef MODIFIER

    SubscribedFolderFactory() = default;
    SubscribedFolderFactory(const SubscribedFolder& src)
            : data_(std::make_shared<SubscribedFolderData>(src.data())) {
    }

    const SubscribedFolderDataInterface<SubscribedFolderFactory>& product() const {
        return *this;
    }

    SubscribedFolderFactory& reset() {
        data_.reset();
        return *this;
    }

    SubscribedFolder release() {
        auto retval = std::move(data_);
        reset();
        return SubscribedFolder(std::move(retval));
    }

    SubscribedFolderFactory(const SubscribedFolderFactory& ) = delete;
    SubscribedFolderFactory& operator=(const SubscribedFolderFactory&) = delete;
private:
    friend class SubscribedFolderDataInterface<SubscribedFolderFactory>;

    SubscribedFolderData& data() {
        if(!data_) {
            data_ = std::make_shared<SubscribedFolderData>();
        }
        return *data_;
    }
    const SubscribedFolderData& data() const {
        return data_ ? *data_ : SubscribedFolderData::default_;
    }

    std::shared_ptr<SubscribedFolderData> data_;
};

} // namespace macs

#undef MODIFIER

#endif // MACS_SUBSCRIBED_FOLDER_FACTORY_H
