#ifndef MACS_SUBSCRIBED_FOLDERS_SUBSCRIBED_FOLDER_H
#define MACS_SUBSCRIBED_FOLDERS_SUBSCRIBED_FOLDER_H

#include <macs/types.h>
#include <macs/revision.h>

namespace macs {

struct SubscribedFolderData {
    using Uid = std::string;
    Uid uid;
    Fid fid;
    Revision revision = 0;
    Uid ownerUid;
    Fid ownerFid;
    Revision syncedRevision = 0;
    time_t created = 0;

    static const SubscribedFolderData default_;
};

template<typename Impl>
class SubscribedFolderDataInterface {
public:
#define GETTER(NAME) auto& NAME() const { return data().NAME; }
    GETTER(uid)
    GETTER(fid)
    GETTER(revision)
    GETTER(ownerUid)
    GETTER(ownerFid)
    GETTER(syncedRevision)
    GETTER(created)
#undef GETTER
protected:
    SubscribedFolderDataInterface() = default;

    const SubscribedFolderData& data() const {
        return static_cast<const Impl&>(*this).Impl::data();
    }
};

class SubscribedFolder: public SubscribedFolderDataInterface<SubscribedFolder> {
public:
    SubscribedFolder() = default;
    SubscribedFolder(std::shared_ptr<const SubscribedFolderData> data): data_(std::move(data))
            {}
private:
    friend class SubscribedFolderFactory;
    friend class SubscribedFolderDataInterface<SubscribedFolder>;
    const SubscribedFolderData& data() const {
        return data_ ? *data_ : SubscribedFolderData::default_;
    }
    std::shared_ptr<const SubscribedFolderData> data_;
};

} //namespace macs

#endif //MACS_SUBSCRIBED_FOLDERS_SUBSCRIBED_FOLDER_H
