#ifndef MACS_SUBSCRIPTION_FACTORY_H_07032017
#define MACS_SUBSCRIPTION_FACTORY_H_07032017

#include <macs_pg/subscription/subscription.h>

namespace macs {

class SubscriptionFactory: private SubscriptionDataInterface<SubscriptionFactory> {
public:

#define MODIFIER(NAME) \
    SubscriptionFactory & NAME (const decltype(SubscriptionData::NAME) & v) { \
        data().NAME = std::move(v); \
        return *this; \
    }

    MODIFIER(uid)
    MODIFIER(subscriptionId)
    MODIFIER(fid)
    MODIFIER(subscriberUid)
    MODIFIER(workerId)
    MODIFIER(state)

#undef MODIFIER

    SubscriptionFactory() = default;
    SubscriptionFactory(const Subscription& src)
    : data_(std::make_shared<SubscriptionData>(src.data())) {
    }

    const SubscriptionDataInterface<SubscriptionFactory>& product() const {
        return *this;
    }

    SubscriptionFactory& reset() {
        data_.reset();
        return *this;
    }

    Subscription release() {
        auto retval = std::move(data_);
        reset();
        return Subscription(std::move(retval));
    }

    SubscriptionFactory(const SubscriptionFactory& ) = delete;
    SubscriptionFactory(SubscriptionFactory&&) = default;
    SubscriptionFactory& operator=(const SubscriptionFactory&) = delete;
    SubscriptionFactory& operator=(SubscriptionFactory&&) = default;
private:
    friend class SubscriptionDataInterface<SubscriptionFactory>;

    SubscriptionData& data() {
        if(!data_) {
            data_ = std::make_shared<SubscriptionData>();
        }
        return *data_;
    }
    const SubscriptionData& data() const {
        return data_ ? *data_ : SubscriptionData::default_;
    }

    std::shared_ptr<SubscriptionData> data_;
};

} // namespace macs

#undef MODIFIER

#endif // MACS_SUBSCRIPTION_FACTORY_H_07032017
