#ifndef MACS_SUBSCRIPTION_H_07032017
#define MACS_SUBSCRIPTION_H_07032017

#include <string>
#include <boost/optional.hpp>
#include <macs/types.h>
#include <macs_pg/subscription/subscription_state.h>
#include <macs_pg/subscription/types.h>

namespace macs {

struct SubscriptionData {
    using Uid = std::string;
    using State = macs::pg::SubscriptionState;

    Uid uid;
    SubscriptionId subscriptionId;
    Fid fid;
    Uid subscriberUid;
    boost::optional<WorkerId> workerId;
    State state = State::unknown;

    static const SubscriptionData default_;
};

template <typename Impl>
class SubscriptionDataInterface {
public:
#define GETTER(NAME) auto& NAME() const { return data().NAME; }
    GETTER(uid)
    GETTER(subscriptionId)
    GETTER(fid)
    GETTER(subscriberUid)
    GETTER(workerId)
    GETTER(state)
#undef GETTER
private:
    friend Impl;
    SubscriptionDataInterface() = default;
    SubscriptionDataInterface(const SubscriptionDataInterface&) = default;
    SubscriptionDataInterface(SubscriptionDataInterface&&) = default;
    SubscriptionDataInterface& operator = (const SubscriptionDataInterface&) = default;
    SubscriptionDataInterface& operator = (SubscriptionDataInterface&&) = default;

    const SubscriptionData& data() const {
        return static_cast<const Impl&>(*this).Impl::data();
    }
};

class Subscription: public SubscriptionDataInterface<Subscription> {
public:
    Subscription() = default;
    Subscription(std::shared_ptr<const SubscriptionData> data): data_(std::move(data))
        {}
    Subscription(const Subscription&) = default;
    Subscription(Subscription&&) = default;
    Subscription& operator=(const Subscription&) = default;
    Subscription& operator=(Subscription&&) = default;
protected:
    friend class SubscriptionFactory;
    friend class SubscriptionDataInterface<Subscription>;
    const SubscriptionData& data() const {
        return data_ ? *data_ : SubscriptionData::default_;
    }
    std::shared_ptr<const SubscriptionData> data_;
};


} // namespace macs


#endif /* MACS_SUBSCRIPTION_H_07032017 */
