#pragma once

#include <string>
#include <boost/optional.hpp>
#include <macs/types.h>

namespace macs {

struct UnsubscribeTaskData {
    uint64_t taskId = 0;
    std::string taskRequestId;
    Uid ownerUid;
    std::vector<Fid> ownerFids;
    Uid subscriberUid;
    Fid rootSubscriberFid;

    static const UnsubscribeTaskData default_;
};

template <typename Impl>
class UnsubscribeTaskDataInterface {
public:
#define GETTER(NAME) auto& NAME() const { return data().NAME; }
    GETTER(taskId)
    GETTER(taskRequestId)
    GETTER(ownerUid)
    GETTER(ownerFids)
    GETTER(subscriberUid)
    GETTER(rootSubscriberFid)
#undef GETTER
private:
    friend Impl;
    UnsubscribeTaskDataInterface() = default;
    UnsubscribeTaskDataInterface(const UnsubscribeTaskDataInterface&) = default;
    UnsubscribeTaskDataInterface(UnsubscribeTaskDataInterface&&) = default;
    UnsubscribeTaskDataInterface& operator = (const UnsubscribeTaskDataInterface&) = default;
    UnsubscribeTaskDataInterface& operator = (UnsubscribeTaskDataInterface&&) = default;

    const UnsubscribeTaskData& data() const {
        return static_cast<const Impl&>(*this).Impl::data();
    }
};

class UnsubscribeTask: public UnsubscribeTaskDataInterface<UnsubscribeTask> {
public:
    UnsubscribeTask() = default;
    UnsubscribeTask(std::shared_ptr<const UnsubscribeTaskData> data): data_(std::move(data))
        {}
    UnsubscribeTask(const UnsubscribeTask&) = default;
    UnsubscribeTask(UnsubscribeTask&&) = default;
    UnsubscribeTask& operator=(const UnsubscribeTask&) = default;
    UnsubscribeTask& operator=(UnsubscribeTask&&) = default;
protected:
    friend class UnsubscribeTaskFactory;
    friend class UnsubscribeTaskDataInterface<UnsubscribeTask>;
    const UnsubscribeTaskData& data() const {
        return data_ ? *data_ : UnsubscribeTaskData::default_;
    }
    std::shared_ptr<const UnsubscribeTaskData> data_;
};



} // namespace macs

