#pragma once

#include <macs_pg/subscription/unsubscribe_task.h>

namespace macs {

class UnsubscribeTaskFactory: private UnsubscribeTaskDataInterface<UnsubscribeTaskFactory> {
public:

#define MODIFIER(NAME) \
    UnsubscribeTaskFactory & NAME (const decltype(UnsubscribeTaskData::NAME) & v) { \
        data().NAME = std::move(v); \
        return *this; \
    }

    MODIFIER(taskId)
    MODIFIER(taskRequestId)
    MODIFIER(ownerUid)
    MODIFIER(ownerFids)
    MODIFIER(subscriberUid)
    MODIFIER(rootSubscriberFid)

#undef MODIFIER

    UnsubscribeTaskFactory() = default;
    UnsubscribeTaskFactory(const UnsubscribeTask& src)
    : data_(std::make_shared<UnsubscribeTaskData>(src.data())) {
    }

    const UnsubscribeTaskDataInterface<UnsubscribeTaskFactory>& product() const {
        return *this;
    }

    UnsubscribeTaskFactory& reset() {
        data_.reset();
        return *this;
    }

    UnsubscribeTask release() {
        auto retval = std::move(data_);
        reset();
        return UnsubscribeTask(std::move(retval));
    }

    UnsubscribeTaskFactory(const UnsubscribeTaskFactory& ) = delete;
    UnsubscribeTaskFactory(UnsubscribeTaskFactory&&) = default;
    UnsubscribeTaskFactory& operator=(const UnsubscribeTaskFactory&) = delete;
    UnsubscribeTaskFactory& operator=(UnsubscribeTaskFactory&&) = default;
private:
    friend class UnsubscribeTaskDataInterface<UnsubscribeTaskFactory>;

    UnsubscribeTaskData& data() {
        if(!data_) {
            data_ = std::make_shared<UnsubscribeTaskData>();
        }
        return *data_;
    }
    const UnsubscribeTaskData& data() const {
        return data_ ? *data_ : UnsubscribeTaskData::default_;
    }

    std::shared_ptr<UnsubscribeTaskData> data_;
};

} // namespace macs

