#include <internal/backup/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs::pg {

template <>
BackupsRepositoryPtr createBackupsRepository(
    const pgg::fb::DatabaseGenerator& db,
    const std::string& uid,
    pgg::query::RepositoryPtr queryRepository,
    logging::v2::LogPtr logger,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<BackupsRepository<pgg::fb::DatabaseGenerator>>(db, uid, queryRepository, logger, requestInfo);
}

template <>
BackupsRepositoryPtr createBackupsRepository(
    const ConnectionWrapper& db,
    const std::string& uid,
    pgg::query::RepositoryPtr queryRepository,
    logging::v2::LogPtr logger,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<BackupsRepository<ConnectionWrapper>>(db, uid, queryRepository, logger, requestInfo);
}

}
