#include <internal/changelog/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
UserChangeLogRepositoryPtr createUserChangeLogRepository(
    const std::string& uid,
    pgg::fb::DatabaseGenerator dbg,
    pgg::query::RepositoryPtr repo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<UserChangeLogRepository<pgg::fb::DatabaseGenerator>>(
        uid, std::move(dbg), repo, timeout);
}

template<>
UserChangeLogRepositoryPtr createUserChangeLogRepository(
    const std::string& uid,
    ConnectionWrapper dbg,
    pgg::query::RepositoryPtr repo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<UserChangeLogRepository<ConnectionWrapper>>(
        uid, std::move(dbg), repo, timeout);
}

} // namespace pg
} // namespace macs
