#include <internal/collectors/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
CollectorsRepositoryPtr createCollectorsRepository(
    const std::string& uid,
    pgg::fb::DatabaseGenerator dbg,
    pgg::query::RepositoryPtr repo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<CollectorsRepository<pgg::fb::DatabaseGenerator>>(
        uid, std::move(dbg), repo, timeout);
}

template<>
CollectorsRepositoryPtr createCollectorsRepository(
    const std::string& uid,
    ConnectionWrapper dbg,
    pgg::query::RepositoryPtr repo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<CollectorsRepository<ConnectionWrapper>>(
        uid, std::move(dbg), repo, timeout);
}

} // namespace pg
} // namespace macs
