#include <internal/database/database_info.h>

namespace macs::pg {

DatabaseState::State resolveDbState(const pgg::ShardInfo& shard) {
    DatabaseState::State state = DatabaseState::State::dbDead;
    int aliveMasters = boost::count(shard.aliveEndpoints, pgg::ShardInfo::Endpoint::master);
    int aliveReplicas = boost::count(shard.aliveEndpoints, pgg::ShardInfo::Endpoint::replica);

    if (aliveMasters > 0) {
        if (aliveReplicas <= 0) {
            state = DatabaseState::State::masterOnly;
        } else if (aliveReplicas == 1) {
            state = DatabaseState::State::singleReplica;
        } else {
            state = DatabaseState::State::readWrite;
        }
    } else {
        if (aliveReplicas <= 0) {
            state = DatabaseState::State::dbDead;
        } else if (aliveReplicas == 1) {
            state = DatabaseState::State::singleReplicaOnly;
        } else {
            state = DatabaseState::State::readOnly;
        }
    }

    return state;
}
} // namespace macs::pg

