#include <internal/envelope/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
EnvelopesRepositoryPtr createEnvelopesRepository(
    macs::UserJournalPtr journal,
    pgg::fb::DatabaseGenerator dbg,
    LabelsRepositoryPtr labelsRepository,
    FoldersRepositoryPtr foldersRepository,
    TabsRepositoryPtr tabsRepository,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<EnvelopesRepository<pgg::fb::DatabaseGenerator>>(
        journal,
        std::move(dbg),
        labelsRepository,
        foldersRepository,
        tabsRepository,
        uid,
        repo,
        requestInfo,
        timeout);
}

template<>
EnvelopesRepositoryPtr createEnvelopesRepository(
    macs::UserJournalPtr journal,
    ConnectionWrapper dbg,
    LabelsRepositoryPtr labelsRepository,
    FoldersRepositoryPtr foldersRepository,
    TabsRepositoryPtr tabsRepository,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<EnvelopesRepository<ConnectionWrapper>>(
        journal,
        std::move(dbg),
        labelsRepository,
        foldersRepository,
        tabsRepository,
        uid,
        repo,
        requestInfo,
        timeout);
}

} // namespace pg
} // namespace macs
