#include <internal/envelope/recipient.h>

#include <butil/email/email.h>
#include <butil/email/helpers.h>

namespace macs {
namespace pg {

std::vector<Recipient> & fromStringWithType( const std::string & src,
        Recipient::Type type, std::vector<Recipient> & out ) {
    const auto emails = EmailHelpers::toEmailVec(src);
    for( const auto & i : emails ) {
        out.emplace_back(i.displayName(), i.addressString(), type);
    }
    return out;
}

} // namespace pg
} // namespace macs

