#include <internal/folder/clear_cascade_transaction.h>

namespace macs {
namespace pg {

ClearCascadeTransaction::ClearCascadeTransaction(pgg::query::RepositoryPtr qr, OnUpdateMessages h,
        const FolderSet &fs, const std::string& rootFid, const std::string& uid,
        const pgg::RequestInfo& requestInfo, pgg::Milliseconds timeout)
        : queryRepository(qr), hook(std::move(h)), uid(uid), clearData(fs, rootFid),
          revision(NULL_REVISION), affectedMessages(0), requestInfo(requestInfo),
          timeout_(timeout) {
}

void ClearCascadeTransaction::checkError(error_code result) const {
    if (result) {
        hook(result);
    }
}

void ClearCascadeTransaction::externalHook() const {
    hook({revision, affectedMessages});
}

} //namespace pg
} //namespace macs
