#include <internal/folder/create_folder_by_path.h>

namespace macs {
namespace pg {

CreateFolderByPath::CreateFolderByPath(pgg::query::RepositoryPtr queryRepository,
            Folder::Path path, const Uid& uid, const pgg::RequestInfo& requestInfo,
            pgg::Milliseconds timeout, OnUpdateFolder hook)
        : queryRepository(std::move(queryRepository)),
          uid(uid),
          path(std::move(path)),
          requestInfo(requestInfo),
          timeout(timeout),
          hook(std::move(hook)) {
}

std::pair<CreateFolderByPath::PathIt, Fid> CreateFolderByPath::advanceToFirstNonexistentFolder(PathIt currentName, Fid parentFid) const {
    while (true) {
        if (currentName == path.end()) {
            break;
        }
        const auto it = folders.find(*currentName, parentFid);
        if (it == folders.end()) {
            break;
        }
        parentFid = it->second.fid();
        ++currentName;
    }
    return {currentName, std::move(parentFid)};
}

error_code CreateFolderByPath::canCreateFolders(PathIt begin, PathIt end, const Fid& parentFid) const {
    if (begin == end) {
        return error_code();
    }
    if (const auto ec = folders.checkCanCreateFolder(*begin, parentFid, false)) {
        return ec;
    }
    return folders.size() + std::size_t(end - begin) <= FolderSet::MAX_FOLDERS_NUMBER
            ? error_code()
            : error_code(macs::error::foldersLimitExceeded, "folders number limit exceeded");
}

void CreateFolderByPath::onCreateFolder(error_code ec, Folder folder) {
    if (ec) {
        return hook(std::move(ec));
    }
    lastFolder = std::move(folder);
}

} //namespace pg
} //namespace macs
