#include <pgg/cast.h>
#include <internal/folder/modify_master.h>
#include <internal/folder/factory.h>
#include <chrono>

namespace macs {
namespace pg {

ModifyMaster::ModifyMaster(pgg::query::RepositoryPtr qr, OnUpdateFolder h,
        const Folder& f, Folder::Path fodlerPath, FolderSet fs, const std::string& uid,
        const pgg::RequestInfo& requestInfo, pgg::Milliseconds timeout)
        : queryRepository(qr),
          folderSet(fs),
          uid(uid),
          currentParent(root),
          folder(f),
          hook(std::move(h)),
          requestInfo(requestInfo),
          timeout_(timeout) {
    path = std::list<std::string>(fodlerPath.begin(), fodlerPath.end());
    parentsVec = boost::make_iterator_range(path.begin(), --(path.end()));
}

void ModifyMaster::checkError(error_code result) {
    if (result) {
        hook(result, macs::Folder());
    }
}

void ModifyMaster::externalHook() const {
    hook(error_code(), resultFolder);
}

std::string ModifyMaster::getUniqueFolderName() const {
    const auto currentTime = std::chrono::system_clock::now();
    return "temp_" + std::to_string(std::chrono::system_clock::to_time_t(currentTime));
}

} //namespace pg
} //namespace macs
