#include <internal/folder/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
FoldersRepositoryPtr createFoldersRepository(
    macs::UserJournalPtr journal,
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    pgg::Milliseconds timeout,
    logging::v2::LogPtr logger)
{
    return std::make_shared<FoldersRepository<pgg::fb::DatabaseGenerator>>(
        journal, std::move(dbg), uid, repo, requestInfo, timeout, logger);
}

template<>
FoldersRepositoryPtr createFoldersRepository(
    macs::UserJournalPtr journal,
    ConnectionWrapper dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    pgg::Milliseconds timeout,
    logging::v2::LogPtr logger)
{
    return std::make_shared<FoldersRepository<ConnectionWrapper>>(
        journal, std::move(dbg), uid, repo, requestInfo, timeout, logger);
}

} // namespace pg
} // namespace macs
