#include <internal/imap/repository_imap.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
ImapRepositoryPtr createImapRepository(
    macs::UserJournalPtr journal,
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<ImapRepository<pgg::fb::DatabaseGenerator>>(
        journal, std::move(dbg), uid, repo, requestInfo);
}

template<>
ImapRepositoryPtr createImapRepository(
    macs::UserJournalPtr journal,
    ConnectionWrapper dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<ImapRepository<ConnectionWrapper>>(
        journal, std::move(dbg), uid, repo, requestInfo);
}

} // namespace pg
} // namespace macs
