#include <internal/label/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
LabelsRepositoryPtr createLabelsRepository(
    macs::UserJournalPtr journal,
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<LabelsRepository<pgg::fb::DatabaseGenerator>>(
        journal, std::move(dbg), uid, repo, requestInfo);
}

template<>
LabelsRepositoryPtr createLabelsRepository(
    macs::UserJournalPtr journal,
    ConnectionWrapper dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<LabelsRepository<ConnectionWrapper>>(
        journal, std::move(dbg), uid, repo, requestInfo);
}

} // namespace pg
} // namespace macs
