#include <macs_pg/logging.h>

#include <boost/range/algorithm/find_if.hpp>

namespace macs {
namespace pg {
namespace logging {

using namespace pgg::logging;

static const Message& getMessage(const Attributes& attributes, const Message& message) {
    const auto iter = boost::find_if(attributes, [](const auto& attr) {
        return attr.type() == typeid(OldMessage);
    });
    if (iter != attributes.end()) {
        return static_cast<const Message&>(boost::get<OldMessage>(*iter));
    } else {
        return message;
    }
}

class OldLogAdapter : public v2::Log {
    LogPtr logger;
public:
    explicit OldLogAdapter(LogPtr logger)
        : logger(std::move(logger))
    {}

    void log(const Level level, const Method& method, const Message& message,
             Attributes attributes) override {
        const auto& msg = getMessage(attributes, message);
        switch (level) {
        case Level::Warning:
            logger->warning(method, msg);
            break;
        case Level::Error:
            logger->error(method, msg);
            break;
        case Level::Notice:
            logger->notice(method, msg);
            break;
        case Level::Debug:
            logger->debug(method, msg);
            break;
        }
    }

    bool applicable(const Level) noexcept override {
        return true;
    }
};

v2::LogPtr adaptLog(LogPtr log) {
    return std::make_shared<OldLogAdapter>(std::move(log));
}

} // namespace logging
} // namespace pg
} // namesopace macs
