#include <internal/mailish/account.h>

#include <macs_pg/mailish/account_factory.h>
#include <internal/reflection/mailish_account.h>

namespace macs {

const MailishAccount::Data MailishAccount::Data::default_{};

namespace pg {

MailishAccount toMailishAccount(const reflection::MailishAccount& v) {
    MailishAccountFactory factory;
    factory
        .uid(std::to_string(v.uid))
        .email(v.email)
        .imapLogin(v.imap_login)
        .imapSsl(v.imap_ssl)
        .imapServer(v.imap_server)
        .imapPort(static_cast<uint32_t>(v.imap_port))
        .smtpLogin(v.smtp_login)
        .smtpSsl(v.smtp_ssl)
        .smtpServer(v.smtp_server)
        .smtpPort(static_cast<uint32_t>(v.smtp_port))
        .lastSyncTs(v.last_sync);

    return factory.release();
}

} // namespace pg

} // namespace macs
