#include <internal/mailish/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
MailishRepositoryPtr createMailishRepository(
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    FoldersRepositoryPtr foldersRepository,
    LabelsRepositoryPtr labelsRepository,
    TabsRepositoryPtr tabsRepository,
    pgg::Milliseconds timeout)
{
    return std::make_shared<MailishRepository<pgg::fb::DatabaseGenerator>>(
        std::move(dbg),
        uid,
        repo,
        requestInfo,
        foldersRepository,
        labelsRepository,
        tabsRepository,
        timeout);
}

template<>
MailishRepositoryPtr createMailishRepository(
    ConnectionWrapper dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    FoldersRepositoryPtr foldersRepository,
    LabelsRepositoryPtr labelsRepository,
    TabsRepositoryPtr tabsRepository,
    pgg::Milliseconds timeout)
{
    return std::make_shared<MailishRepository<ConnectionWrapper>>(
        std::move(dbg),
        uid,
        repo,
        requestInfo,
        foldersRepository,
        labelsRepository,
        tabsRepository,
        timeout);
}

} // namespace pg
} // namespace macs
