#include <internal/service/factory.h>
#include <internal/query/query_register_impl.h>
#include <internal/reflection/change_queue.h>

namespace macs {
namespace pg {

const QueryHandleStrategy readMasterThenReplica =
        QueryHandleStrategy(pgg::ReadMasterThenReplica());

const QueryHandleStrategy masterOnly =
        QueryHandleStrategy(pgg::MasterOnly());

const QueryHandleStrategy readReplicaThenMaster =
        QueryHandleStrategy(pgg::ReadReplicaThenMaster());

const QueryHandleStrategy replicaOnly =
        QueryHandleStrategy(pgg::ReplicaOnly());

const QueryHandleStrategy readNoLagReplicaThenMasterThenReplica =
        QueryHandleStrategy(pgg::ReadNoLagReplicaThenMasterThenReplica());

QueryConf readQueryConfFile( const std::string & fileName ) {
    using namespace query;
    return pgg::readQueryConfFile(fileName, Queries(), QueryParameters());
}

}
}
