#include <internal/settings/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs::pg {

template<>
SettingsRepositoryPtr createSettingsRepository<>(
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo
) {
    return std::make_shared<SettingsRepository<pgg::fb::DatabaseGenerator>>(
        dbg, uid, repo, requestInfo);
}

template<>
SettingsRepositoryPtr createSettingsRepository<>(
    ConnectionWrapper dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo
) {
    return std::make_shared<SettingsRepository<ConnectionWrapper>>(
        dbg, uid, repo, requestInfo);
}

}
