#include <yamail/data/deserialization/json_reader.h>

#include <internal/settings/transform.h>

namespace macs::pg {

using namespace macs::settings;

SettingsRawPtr getSettings(const reflection::Settings& settings) {
    SettingsRaw result;
    if (settings.value) {
        yamail::data::deserialization::fromJson<SettingsRaw>(*settings.value, result);
    }
    return std::make_shared<SettingsRaw>(std::move(result));
}

}
