#include <internal/shared_folders/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
SharedFoldersRepositoryPtr createSharedFoldersRepository(
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<SharedFoldersRepository<pgg::fb::DatabaseGenerator>>(
        std::move(dbg), uid, repo, requestInfo, timeout);
}

template<>
SharedFoldersRepositoryPtr createSharedFoldersRepository(
    ConnectionWrapper dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<SharedFoldersRepository<ConnectionWrapper>>(
        std::move(dbg), uid, repo, requestInfo, timeout);
}

} // namespace pg
} // namespace macs
