#include <mail/macs_pg/include/internal/sticker/repository.h>
#include <internal/service/conn_wrapper.h>

namespace macs::pg {

template <>
StickersRepositoryPtr createStickersRepository(
        macs::UserJournalPtr journal,
        const pgg::fb::DatabaseGenerator& db,
        const std::string& uid,
        pgg::query::RepositoryPtr queryRepository,
        logging::v2::LogPtr logger,
        const pgg::RequestInfo& requestInfo,
        pgg::Milliseconds transactionTimeout
) {
    return std::make_shared<macs::pg::StickersRepository<pgg::fb::DatabaseGenerator>>(journal, db, uid, queryRepository, logger,
            requestInfo, transactionTimeout);
}

template <>
StickersRepositoryPtr createStickersRepository(
        macs::UserJournalPtr journal,
        const ConnectionWrapper& db,
        const std::string& uid,
        pgg::query::RepositoryPtr queryRepository,
        logging::v2::LogPtr logger,
        const pgg::RequestInfo& requestInfo,
        pgg::Milliseconds transactionTimeout
) {
    return std::make_shared<macs::pg::StickersRepository<ConnectionWrapper>>(journal, db, uid, queryRepository, logger,
            requestInfo, transactionTimeout);
}

}
