#include <internal/subscribed_folders/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
SubscribedFoldersRepositoryPtr createSubscribedFoldersRepository(
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    LabelsRepositoryPtr labelsRepositiory,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<SubscribedFoldersRepository<pgg::fb::DatabaseGenerator>>(
        std::move(dbg), uid, labelsRepositiory, repo, requestInfo);
}

template<>
SubscribedFoldersRepositoryPtr createSubscribedFoldersRepository(
    ConnectionWrapper dbg,
    const std::string& uid,
    LabelsRepositoryPtr labelsRepositiory,
    pgg::query::RepositoryPtr repo,
    const pgg::RequestInfo& requestInfo)
{
    return std::make_shared<SubscribedFoldersRepository<ConnectionWrapper>>(
        std::move(dbg), uid, labelsRepositiory, repo, requestInfo);
}

} // namespace pg
} // namespace macs
