#include <internal/subscription/repository.h>
#include <internal/service/conn_wrapper.h>
#include <pgg/database/fallback.h>

namespace macs {
namespace pg {

template<>
SubscriptionRepositoryPtr createSubscriptionRepository(
    pgg::fb::DatabaseGenerator dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<SubscriptionRepository<pgg::fb::DatabaseGenerator>>(
        std::move(dbg), uid, repo, timeout);
}

template<>
SubscriptionRepositoryPtr createSubscriptionRepository(
    ConnectionWrapper dbg,
    const std::string& uid,
    pgg::query::RepositoryPtr repo,
    pgg::Milliseconds timeout)
{
    return std::make_shared<SubscriptionRepository<ConnectionWrapper>>(
        std::move(dbg), uid, repo, timeout);
}

} // namespace pg
} // namespace macs
